//
//  GSPCDNConfig.h
//  PlayerSDK
//
//  Created by 230222 on 2025/11/4.
//  Copyright © 2025 Geensee. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
/**
 *   加入直播后使用的播放器类型
 */
typedef NS_ENUM(NSInteger, GSPPlayerType)
{
    /**
     *  RTMP
     */
    GSPPlayerType_RTMP = 0,
    
    /**
     *  FLV
     */
    GSPPlayerType_FLV = 1,
    
    /**
     *  HLS
     */
    GSPPlayerType_HLS = 2,
    /**
     *  RTMP_CDN
     */
    PlayerType_RTMP_CDN = 3,
};

@interface GSPCDNConfig : NSObject
/// 是否使用了CDN模式
@property (nonatomic, assign) BOOL isUseCdn;
/// 当前使用的CDN线路id
@property (nonatomic, copy) NSString * usingCdnLine;
/// CDN线路列表(数组中为CDN线路id)
@property (nonatomic, copy) NSArray * cdnLineArray;

@end

NS_ASSUME_NONNULL_END
